#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ReagentChange : BaseTest 
	{

		private ReagentChange _tstRC;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_tstRC = new BOL.ReagentChange();
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(!_tstRC.Equals(null));
			Assert.AreEqual(_tstRC,_tstRC);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataTable dt = ReagentChange.InitializeReagentChangeTable();
			DataRow dr = dt.NewRow();
			dr["ReagentChangeGuid"] = Guid.NewGuid();
			_tstRC = new ReagentChange(dr);
			Assert.AreEqual((Guid)dr["ReagentChangeGuid"], _tstRC.ReagentChangeGuid);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void Ctor_DataRow_Fail()
		{
			Assert.IsNull( new ReagentChange( (DataRow)null ) );
		}

		[Test]
		public void ReagentChangeGuid_Pass()
		{
			System.Guid _ReagentChangeGuid;
			_ReagentChangeGuid = _tstRC.ReagentChangeGuid;
			Assert.AreEqual(_tstRC.ReagentChangeGuid,_ReagentChangeGuid);
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=_tstRC.BrokenRulesCount;
			_tstRC.ReagentChangeGuid= System.Guid.NewGuid();
			brokenRulesAfter=_tstRC.BrokenRulesCount;
			Assert.AreEqual(brokenRulesAfter, brokenRulesBefore);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentChangeGuid_Fail()
		{
		}

		[Test]
		public void ReagentGuid_Pass()
		{
			System.Guid _ReagentGuid;
			_ReagentGuid = _tstRC.ReagentGuid;
			Assert.AreEqual(_tstRC.ReagentGuid,_ReagentGuid);

			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=_tstRC.BrokenRulesCount;
			_tstRC.ReagentGuid= System.Guid.NewGuid();
			brokenRulesAfter=_tstRC.BrokenRulesCount;
			Assert.AreEqual(brokenRulesAfter, brokenRulesBefore);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentGuid_Fail()
		{
		}

		[Test]
		public void ReagentChangeDetailCode_Pass()
		{
			System.String _ReagentChangeDetailCode;
			_ReagentChangeDetailCode = _tstRC.ReagentChangeDetailCode;
		Assert.AreEqual(_tstRC.ReagentChangeDetailCode,_ReagentChangeDetailCode);
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=_tstRC.BrokenRulesCount;
			_tstRC.ReagentChangeDetailCode= "O";
			brokenRulesAfter=_tstRC.BrokenRulesCount;
			Assert.AreEqual(brokenRulesAfter, brokenRulesBefore);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentChangeDetailCode_Fail()
		{
		}

		[Test]
		public void InitializeReagentChangeTable_Pass()
		{
			DataTable dtRetVal = ReagentChange.InitializeReagentChangeTable();
			Assert.IsTrue(dtRetVal.Columns.Count > 0);
			Assert.IsTrue(dtRetVal.TableName == "ReagentChange");
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeReagentChangeTable_Fail()
		{
		}

		[Test]
		public void GetReagentChangeDetails_Pass()
		{
			DataTable dtRetVal = ReagentChange.GetReagentChangeDetails();
			Assert.IsTrue(dtRetVal != null);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReagentChangeDetails_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			_tstRC.ReagentChangeGuid = Guid.NewGuid();
			DataTable dt = ReagentChange.InitializeReagentChangeTable();
			DataRow dr = dt.NewRow();
			dr = _tstRC.LoadDataRowFromThis(dr);
			Assert.AreEqual((Guid)dr["ReagentChangeGuid"], _tstRC.ReagentChangeGuid);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail()
		{
			DataTable dt = new DataTable();
			dt.Columns.Add( Guid.Empty.ToString() );
			DataRow dr = dt.NewRow();
			dr = _tstRC.LoadDataRowFromThis(dr);
			Assert.AreEqual( null, dt.NewRow() );
		}


		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
			const string REAGENTCHANGECOLUMNS = "ReagentChangeGuid,ReagentGuid,ReagentChangeDetailCode";
			DataTable dt = ReagentChange.InitializeReagentChangeTable();
			Assert.IsTrue(_tstRC.VerifyMinColumnsInDataTable(REAGENTCHANGECOLUMNS.Split(','), dt));
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{			
			DataTable dt = new DataTable();
			Assert.AreEqual( false, _tstRC.VerifyMinColumnsInDataTable(ReagentChange.REAGENTCHANGECOLUMNS.Split(','), dt) );
		}
	}
}
#endif




